#!/bin/sh
EXE=creator4-arm
SOFTWAREPACKET=software*
SOFTWAREVERSION="2.2.1"
KERNELPACKET=kernel*
KERNELVERSION="4.0.7"
M3HEX=Creator4.hex
M3HEXPACKET=control*
M3HEXVERSION="5.1.8"
LIBPACKET=library*
LIBVERSION="1.0.6"
LOG=/data/log/creator4.log
MACHINE_ARCH=aarch64
VERSIONCFG=version.cfg
BUILDTIME="20230112"
WORKDIR=$(cd `dirname $0`; pwd)
echo "WORKDIR="$WORKDIR >> $LOG
if [ ! -f /opt/$VERSIONCFG ]
then
    touch /opt/$VERSIONCFG
fi
sync
echo "[VersionInfo]" > /opt/$VERSIONCFG
echo "UpdateFlag=0" >> /opt/$VERSIONCFG
echo "BuildTime="$BUILDTIME >> /opt/$VERSIONCFG
echo "SoftwareVersion="$SOFTWAREVERSION >> /opt/$VERSIONCFG
echo "LibVersion="$LIBVERSION >> /opt/$VERSIONCFG
echo "ControlVersion="$M3HEXVERSION >> /opt/$VERSIONCFG
echo "KernelVersion="$KERNELVERSION >> /opt/$VERSIONCFG
#检测机器的架构,错误马上退出
CHECH_ARCH=`uname -m`
if [ "${MACHINE_ARCH}" != "${CHECH_ARCH}" ];then
	echo "updateInfo=Machine architecture error." >> /opt/$VERSIONCFG
	exit 1
fi

cp $WORKDIR/complete.img /opt/
cp $WORKDIR/start.img /opt/


echo "dispaly start on lcd" >> $LOG
if [ -f $WORKDIR/start.img ]
then
    cat $WORKDIR/start.img > /dev/fb0
fi

if [ ! -d /data/log ]; then
	mkdir /data/log
fi

if [ ! -d /data/update ]; then
	mkdir /data/update
fi

if [ ! -d /media ]; then
	mkdir /media
fi

if [ ! -d /opt/kernel ]; then
	mkdir /opt/kernel
fi

if [ ! -d /opt/control ]; then
	mkdir /opt/control
fi

if [ ! -d /opt/library ]; then
	mkdir /opt/library
fi

if [ ! -d /opt/software ]; then
	mkdir /opt/software
fi
if [ -f $WORKDIR/start.img ]
then
   cp -f $WORKDIR/code2000.ttf /opt/qt-5.4.2/lib/fonts/
fi

cp -f $WORKDIR/mydaemon.out /opt/
if [ ! -f $WORKDIR/rerun.sh ]
then
    cp -f $WORKDIR/abort.sh /opt/
    cp -f $WORKDIR/rerun.sh /opt/
    cp -f $WORKDIR/abort.img /opt/

    chmod a+x /opt/rerun.sh
	chmod a+x /opt/abort.sh
fi
sync

if [ -f $WORKDIR/c4-part.gx ]
then
    cp -f $WORKDIR/c4-part.gx /opt/
fi

if [ ! -d /opt/mjpg-streamer ]; then
		echo "tar camera.tar"  >> $LOG
		tar -xvf $WORKDIR/mjpg-streamer.tar -C /opt/
		chmod 777 /opt/mjpg-streamer/* -Rf
		echo "update camera success" >> $LOG
		sync
fi

	
ls -1t $WORKDIR/$KERNELPACKET
if [ $? -eq 0 ]; then
	UIMAGETXZ=`ls -1t $WORKDIR/$KERNELPACKET | head -n 1`
	xz -d  $UIMAGETXZ 
	UIMAGETAR=`ls -1t $WORKDIR/$KERNELPACKET | head -n 1`
	if [ -f $UIMAGETAR ]; then
	    rm -rf /opt/kernel/*	
		mkdir /opt/kernel/temp	
		tar -xf $UIMAGETAR -C /opt/kernel/temp
		if [ ! -d /tmp/disk1 ]; then
			mkdir /tmp/disk1
		fi
		mount -t vfat -o codepage=936,iocharset=utf8 /dev/mmcblk0p1 /tmp/disk1
		if [ $? -ne 0 ]; then
			if [ -f $WORKDIR/failed.img ]; then
				cat $WORKDIR/failed.img > /dev/fb0
			fi
			sync
		fi	
		cd /opt/kernel/temp
		md5sum -c md5sum.list
		if [ $? -eq 0 ]; then		
			cp -rf /opt/kernel/temp /opt/kernel/$KERNELVERSION
			rm -rf /opt/kernel/temp
			UIMAGE=`ls -1t /opt/kernel/$KERNELVERSION/$KERNELPACKET | head -n 1`
			if [ -f $UIMAGE ]; then
				echo "update uImage" >> $LOG
				cp -f $UIMAGE /tmp/disk1/kernel.img
				cp -f /opt/kernel/$KERNELVERSION/logo.bmp /tmp/disk1/logo.bmp
				sync	
				echo "update uImage success" >> $LOG
				umount /tmp/disk1
				rm -r /tmp/disk1
			fi
		else
			echo "md5sum failed" >> $LOG
			if [ -f $WORKDIR/failed.img ]; then
				cat $WORKDIR/failed.img > /dev/fb0
			fi
			sync
			exit 1
		fi	
	fi
fi

sync


ls -1t $WORKDIR/$SOFTWAREPACKET
if [ $? -eq 0 ]; then
	SOFTWAREXZ=`ls -1t $WORKDIR/$SOFTWAREPACKET | head -n 1`
	xz -d $SOFTWAREXZ
	SOFTWARETAR=`ls -1t $WORKDIR/$SOFTWAREPACKET | head -n 1`
	if [ -f $SOFTWARETAR ]; then
		if [ ! -d /opt/software/temp ]; then
			mkdir /opt/software/temp	
		fi
		tar -xf $SOFTWARETAR -C /opt/software/temp
		sync
		cd  /opt/software/
		softwareDir=$(ls -ld [0-9]* |awk '/^d/ {print $NF}')
		for oldSoftwareVer in $softwareDir 
		do
			echo $oldSoftwareVer
		done
		cd /opt/software/temp
		md5sum -c md5sum.list
		if [ $? -eq 0 ]; then	
			if [ "$oldSoftwareVer" > $SOFTWAREVERSION ]; then
				baseDir="0.0.0"
				echo $oldSoftwareVer ">" $SOFTWAREVERSION >> $LOG
				cp -rf /opt/software/$oldSoftwareVer  /opt/software/$baseDir
				cd /opt/software/
				rm -rf $oldSoftwareVer
			fi
			cp -f /opt/software/temp/auto_run.sh   /opt/ 			
			mkdir /opt/software/$SOFTWAREVERSION
			cp -rf /opt/software/temp/* /opt/software/$SOFTWAREVERSION
			rm -rf /opt/software/temp		
			echo "update software success" >> $LOG
			sync
		fi
	fi
fi

sync

ls -1t $WORKDIR/$LIBPACKET
if [ $? -eq 0 ]; then
	cd  /opt/library/
	libDir=$(ls -ld [0-9]* |awk '/^d/ {print $NF}')
	for oldLibVer in $libDir 
	do
		echo $oldLibVer
	done
	if [ "$oldLibVer" == $LIBVERSION ]; then
		echo "The same Lib version!" >> $LOG
	else
		LIBTXZ=`ls -1t $WORKDIR/$LIBPACKET | head -n 1`
		xz -d $LIBTXZ 
		LIBTAR=`ls -1t $WORKDIR/$LIBPACKET | head -n 1`
		if [ -f $LIBTAR ]; then
			if [ ! -d /opt/library/temp ]; then
				mkdir /opt/library/temp	
			fi
			tar -xf $LIBTAR -C /opt/library/temp
			sync
			cd /opt/library/temp
			md5sum -c md5sum.list
			if [ $? -eq 0 ]; then
				mkdir /opt/library/$LIBVERSION
				cp -rf /opt/library/temp/* /opt/library/$LIBVERSION
				rm -rf /opt/library/temp
				cd /opt/library/
				rm -r $oldLibVer
				echo "update LIB" >> $LOG
				sync
			fi
		fi
	fi
fi
sync

if [ -f /lib/modules/wlan.ko ]
then
    rm -f /lib/modules/wlan.ko
	rm -f /lib/modules/compat.ko
	rm -f /lib/modules/cfg80211.ko
fi

cp  -f $WORKDIR/8821cu.ko /lib/modules/

ls -1t $WORKDIR/$M3HEXPACKET
if [ $? -eq 0 ]; then
	M3HEXXZ=`ls -1t $WORKDIR/$M3HEXPACKET | head -n 1`
	xz -d  $M3HEXXZ
	M3HEXTAR=`ls -1t $WORKDIR/$M3HEXPACKET | head -n 1`
	if [ -f $M3HEXTAR ]; then
		rm -rf /opt/control/*
		mkdir /opt/control/temp	
		tar -xf $M3HEXTAR -C /opt/control/temp
		sync
		cd /opt/control/temp
		md5sum -c md5sum.list
		if [ $? -eq 0 ]; then		
			cp -rf /opt/control/temp /opt/control/$M3HEXVERSION
			rm -rf /opt/control/temp
			echo "burn M3 firmware..." >> $LOG
			chmod a+x /opt/control/$M3HEXVERSION/ISPCreator4
			echo 386 > /sys/class/gpio/export
			echo "out" > /sys/class/gpio/gpio386/direction
			echo 1 > /sys/class/gpio/gpio386/value
			/opt/control/$M3HEXVERSION/ISPCreator4 /opt/control/$M3HEXVERSION/$M3HEX
			echo "update $M3HEX success" >> $LOG
			echo "dispaly on lcd" >> $LOG
			
			if [ -f $WORKDIR/complete.img ]
			then
				cat $WORKDIR/complete.img > /dev/fb0
			fi

			if [ -f $WORKDIR/play ]; then
				echo "play complete music" >> $LOG
				chmod a+x $WORKDIR/play
				$WORKDIR/play
			fi
		    echo "UpdateFlag=1" >> /opt/$VERSIONCFG
			echo 385 > /sys/class/gpio/export
			echo "out" > /sys/class/gpio/gpio385/direction
			echo 1 > /sys/class/gpio/gpio385/value
			echo 0 > /sys/class/gpio/gpio385/value	
			sleep 10
			reboot -f
		fi
	fi
else
	echo "UpdateFlag=1" >> /opt/$VERSIONCFG
	if [ -f $WORKDIR/complete.img ]
	then
		cat $WORKDIR/complete.img > /dev/fb0
	fi

	if [ -f $WORKDIR/play ]; then
		echo "play complete music" >> $LOG
		chmod a+x $WORKDIR/play
		$WORKDIR/play 
	fi
fi
sync


